<?php
require 'config.php';
require 'db.php';

$update = json_decode(file_get_contents("php://input"), true);

/* ================= TELEGRAM API ================= */

function tgRequest($method, $data = []){
    $ch = curl_init(API_URL.$method);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_SSL_VERIFYPEER => true
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function sendMessage($chat_id, $text){
    tgRequest('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ]);
}

function sendButtons($chat_id, $text, $buttons){
    tgRequest('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode([
            'inline_keyboard' => $buttons
        ])
    ]);
}

/* ================= TELEGRAM VERIFY ================= */

function isJoinedTelegram($chat_id){
    $res = tgRequest('getChatMember', [
        'chat_id' => '@'.TG_CHANNEL_USERNAME,
        'user_id' => $chat_id
    ]);

    if (!$res['ok']) return false;

    return in_array(
        $res['result']['status'],
        ['member','administrator','creator']
    );
}

/* ================= EARNING FUNCTIONS ================= */

function addTaskEarning($chat_id, $type){
    // type: tw, fb, ig, tg
    $amount = 0.5;

    $user = mysqli_fetch_assoc(mysqli_query($GLOBALS['conn'],
        "SELECT * FROM telegram_users WHERE chat_id='$chat_id'"
    ));

    if(!$user) return;

    // prevent double earning
    if($type == 'tw' && $user['tw_done'] == 1) return;
    if($type == 'fb' && $user['fb_done'] == 1) return;
    if($type == 'ig' && $user['ig_done'] == 1) return;
    if($type == 'tg' && $user['tg_done'] == 1) return;

    if($type == 'tw'){
        mysqli_query($GLOBALS['conn'], "UPDATE telegram_users SET tw_done=1 WHERE chat_id='$chat_id'");
    }
    if($type == 'fb'){
        mysqli_query($GLOBALS['conn'], "UPDATE telegram_users SET fb_done=1 WHERE chat_id='$chat_id'");
    }
    if($type == 'ig'){
        mysqli_query($GLOBALS['conn'], "UPDATE telegram_users SET ig_done=1 WHERE chat_id='$chat_id'");
    }
    if($type == 'tg'){
        mysqli_query($GLOBALS['conn'], "UPDATE telegram_users SET tg_done=1 WHERE chat_id='$chat_id'");
    }

    // add earning
    mysqli_query($GLOBALS['conn'],
        "UPDATE telegram_users 
         SET task_earning = task_earning + $amount,
             wallet_balance = wallet_balance + $amount
         WHERE chat_id='$chat_id'"
    );
}

function addReferralEarningToParent($child_chat_id){
    $amount = 0.5;

    $child = mysqli_fetch_assoc(mysqli_query($GLOBALS['conn'],
        "SELECT referred_by FROM telegram_users WHERE chat_id='$child_chat_id'"
    ));

    if(!$child || empty($child['referred_by'])) return;

    $parent = $child['referred_by'];

    // give referral earning
    mysqli_query($GLOBALS['conn'],
        "UPDATE telegram_users 
         SET referral_earning = referral_earning + $amount,
             wallet_balance = wallet_balance + $amount
         WHERE referral_code='$parent'"
    );
}

/* ================= MAIN MESSAGE ================= */

if (isset($update['message'])) {

    $chat_id = $update['message']['chat']['id'];
    $text    = trim($update['message']['text']);

    mysqli_query($GLOBALS['conn'],
        "INSERT IGNORE INTO telegram_users (chat_id, referral_code) 
         VALUES ('$chat_id','$chat_id')"
    );

    $user = mysqli_fetch_assoc(
        mysqli_query($GLOBALS['conn'],
            "SELECT * FROM telegram_users WHERE chat_id='$chat_id'")
    );

    /* ---------- START ---------- */
    if (strpos($text,'/start') === 0) {

        $parts = explode(" ", $text);

        // referral system
        if (isset($parts[1]) && empty($user['referred_by']) && $parts[1] != $chat_id) {
            mysqli_query($GLOBALS['conn'],
                "UPDATE telegram_users SET referred_by='{$parts[1]}' WHERE chat_id='$chat_id'"
            );
            mysqli_query($GLOBALS['conn'],
                "UPDATE telegram_users SET referrals=referrals+1 WHERE referral_code='{$parts[1]}'"
            );
        }

        // if completed show menu
        if ($user['completed']) {
            $ref = "https://t.me/".BOT_USERNAME."?start=".$chat_id;

            sendButtons(
                $chat_id,
                "✅ <b>You already participated.</b>\n\n".
                "🔗 <b>Your Referral Link:</b>\n$ref\n\nChoose option 👇",
                [
                    [
                        ['text'=>'💰 Wallet Balance', 'callback_data'=>'wallet_balance'],
                        ['text'=>'👥 Referral List', 'callback_data'=>'referral_list']
                    ]
                ]
            );
            exit;
        }

        // show tasks buttons
   
   
        
        
        sendButtons(
    $chat_id,
    "🚀 <b>BNB Cash Airdrop</b>\n\nComplete the tasks below 👇",
    [
        [['text'=>'Twitter - $0.5','callback_data'=>'task_tw']],
        [['text'=>'Facebook - $0.5','callback_data'=>'task_fb']],
        [['text'=>'Instagram - $0.5','callback_data'=>'task_ig']],
        [['text'=>'Telegram - $0.5','url'=>TG_CHANNEL_LINK]],
        [['text'=>'➡️ Proceed to Next','callback_data'=>'proceed']]
    ]
);




        exit;
    }

    /* ---------- WALLET ---------- */
    if ($user['step'] === 'wallet') {

        if (!preg_match('/^0x[a-fA-F0-9]{40}$/', $text)) {
            sendMessage($chat_id,"❌ Invalid BEP20 wallet address.");
            exit;
        }

        mysqli_query($GLOBALS['conn'],
            "UPDATE telegram_users SET wallet='$text', step='email' WHERE chat_id='$chat_id'"
        );

        sendMessage($chat_id,"📧 Enter your Email ID:");
        exit;
    }

    /* ---------- EMAIL ---------- */
  
  /* ---------- EMAIL ---------- */
if ($user['step'] === 'email') {

    if (!filter_var($text, FILTER_VALIDATE_EMAIL)) {
        sendMessage($chat_id,"❌ Invalid email address.");
        exit;
    }

    // Mark completed
    mysqli_query($conn,
        "UPDATE telegram_users 
         SET email='$text', completed=1, step=NULL 
         WHERE chat_id='$chat_id'"
    );

    /* ✅ ADD REFERRAL INCOME HERE */
    if (!empty($user['referred_by'])) {

        // Add referral earning to referrer
        mysqli_query($conn,
            "UPDATE telegram_users 
             SET referral_earning = referral_earning + 0.5,
                 wallet_balance   = wallet_balance + 0.5
             WHERE chat_id='{$user['referred_by']}'"
        );
    }

    // Referral link
    $ref = "https://t.me/".BOT_USERNAME."?start=".$chat_id;

    sendButtons($chat_id,
        "🎉 <b>Successfully Completed!</b>\n\n".
        "🔗 <b>Your Referral Link:</b>\n$ref\n\n".
        "Use buttons below 👇",
        [
            [
                ['text'=>'💰 Wallet Balance','callback_data'=>'wallet_balance'],
                ['text'=>'👥 Referral List','callback_data'=>'referral_list']
            ]
        ]
    );
    exit;
}




}

/* ================= CALLBACK ================= */

if (isset($update['callback_query'])) {

    $chat_id = $update['callback_query']['message']['chat']['id'];
    $data    = $update['callback_query']['data'];

    // Proceed button check telegram + add earnings
    if ($data === 'proceed') {

        if (!isJoinedTelegram($chat_id)) {
            sendMessage($chat_id,
                "❌ <b>Telegram channel is mandatory.</b>\nPlease join and click Proceed again."
            );
            exit;
        }

        // add telegram task earning once
        addTaskEarning($chat_id, 'tg');

        // referral earning to parent if child joined telegram
     //   addReferralEarningToParent($chat_id);

        mysqli_query($GLOBALS['conn'],
            "UPDATE telegram_users SET telegram_verified=1, step='wallet' WHERE chat_id='$chat_id'"
        );

        sendMessage($chat_id,
            "✅ Telegram verified!\n\n💳 Enter your BEP20 wallet address:"
        );
        exit;
    }

    // Wallet Balance tab
    if ($data === 'wallet_balance') {

        $u = mysqli_fetch_assoc(mysqli_query($GLOBALS['conn'],
            "SELECT wallet_balance, referral_earning, task_earning FROM telegram_users WHERE chat_id='$chat_id'"
        ));

        $bal = number_format((float)($u['wallet_balance'] ?? 0), 2);
        $task = number_format((float)($u['task_earning'] ?? 0), 2);
        $refEarn = number_format((float)($u['referral_earning'] ?? 0), 2);

        sendButtons(
            $chat_id,
            "💰 <b>Your Wallet Balance</b>\n\n".
            "Total Balance: <b>$".$bal."</b>\n".
            "Task Income: <b>$".$task."</b>\n".
            "Referral Income: <b>$".$refEarn."</b>\n\nChoose option 👇",
            [
                [
                    ['text'=>'👥 Referral List', 'callback_data'=>'referral_list']
                ]
            ]
        );
        exit;
    }

    // Referral List tab (Email only)
    if ($data === 'referral_list') {

        $rows = mysqli_query($GLOBALS['conn'],
            "SELECT email 
             FROM telegram_users 
             WHERE referred_by='$chat_id' AND completed=1
             ORDER BY id DESC 
             LIMIT 50"
        );

        $msg = "👥 <b>Your Referral List</b>\n\n";

        if (mysqli_num_rows($rows) == 0) {
            $msg .= "No referrals completed yet ❌\n\nShare your referral link to earn more 🚀";
        } else {
            $i = 1;
            while ($r = mysqli_fetch_assoc($rows)) {
                $email = $r['email'] ? $r['email'] : "N/A";
                $msg .= "✅ <b>#".$i."</b> ".$email."\n";
                $i++;
            }
        }

        sendButtons(
            $chat_id,
            $msg,
            [
                [
                    ['text'=>'💰 Wallet Balance', 'callback_data'=>'wallet_balance']
                ]
            ]
        );
        exit;
    }
    
    
    
    // Twitter task
if ($data === 'task_tw') {
    addTaskEarning($chat_id, 'tw');
    sendMessage($chat_id, "Follow Twitter:\n".TWITTER_LINK);
    exit;
}

// Facebook task
if ($data === 'task_fb') {
    addTaskEarning($chat_id, 'fb');
    sendMessage($chat_id, "Follow Facebook:\n".FACEBOOK_LINK);
    exit;
}

// Instagram task
if ($data === 'task_ig') {
    addTaskEarning($chat_id, 'ig');
    sendMessage($chat_id, "Follow instagram:\n".INSTA_LINK);
    exit;
}




}
